<?php
require_once __DIR__.'/../../includes/config.php';
require_once __DIR__.'/../../includes/functions.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    exit('Método no permitido');
}

if (!csrf_check_token($_POST['csrf'] ?? '')) {
    http_response_code(400);
    exit('CSRF inválido');
}

// Iniciar sesión solo si no está activa
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$role = $_SESSION['user']['role'] ?? '';

try {
    if ($role === 'user') {
        // El usuario solo puede crear citas
        $fecha = $_POST['fecha'] ?? '';
        if (!$fecha) throw new Exception('Fecha requerida');
        $stmt = $pdo->prepare('INSERT INTO reformas_citas (user_id, appointment_dt, status) VALUES (?, ?, ?)');
        $stmt->execute([$_SESSION['user']['id'], $fecha, 'pendiente']);
        echo 'Cita solicitada';

    } elseif ($role === 'admin') {
        // El admin solo puede actualizar citas
        $id = (int)($_POST['id'] ?? 0);
        $status = $_POST['status'] ?? '';
        if (!$id || !$status) throw new Exception('ID y estado requeridos');
        $stmt = $pdo->prepare('UPDATE reformas_citas SET status=? WHERE id=?');
        $stmt->execute([$status, $id]);
        echo 'Cita actualizada';

    } else {
        http_response_code(403);
        echo 'No autorizado';
    }
} catch (Exception $e) {
    http_response_code(400);
    echo 'Error: ' . htmlspecialchars($e->getMessage());
}
