<?php
if (session_status() === PHP_SESSION_NONE) session_start();

require_once __DIR__ . '/../../includes/config.php';
require_once __DIR__ . '/../../includes/functions.php';
require_once __DIR__ . '/../../includes/mailer.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') die('Método no permitido');

// 🔒 CSRF
if (!csrf_check_token($_POST['csrf'] ?? '')) die('CSRF inválido');

// 📧 Datos del formulario
$dest_email = trim($_POST['destinatario_email'] ?? '');
$role_dest  = $_POST['role_destinatario'] ?? '';
$asunto     = trim($_POST['asunto'] ?? '');
$mensaje    = trim($_POST['mensaje'] ?? '');
$fecha_prog = $_POST['fecha_programada'] ?? null;

if (!$asunto || !$mensaje) die('Faltan campos obligatorios');

// 🕐 Si hay fecha programada → guardar en BD
if ($fecha_prog) {
    $stmt = $pdo->prepare("INSERT INTO examen_mensajes 
        (destinatario_email, role_destinatario, asunto, mensaje, fecha_programada)
        VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$dest_email ?: null, $role_dest ?: null, $asunto, $mensaje, $fecha_prog]);
}
// 🚀 Si no hay fecha → enviar ahora
else {
    $emails = [];

    if ($dest_email) {
        $emails[] = $dest_email;
    }

    if ($role_dest) {
        $stmt = $pdo->prepare("SELECT email FROM examen_usuarios WHERE role = ?");
        $stmt->execute([$role_dest]);
        $emails = array_merge($emails, $stmt->fetchAll(PDO::FETCH_COLUMN));
    }

    $emails = array_unique($emails);

    foreach ($emails as $e) {
        enviar_correo($e, $asunto, nl2br($mensaje));
    }
}

header('Location: ../dashboard_admin.php');
exit;
?>
