<?php
require_once __DIR__ . '/includes/config.php';
require_once __DIR__ . '/includes/mailer.php';

// Obtener usuarios cuyo cumpleaños es hoy (día y mes)
$stmt = $pdo->prepare("
    SELECT id, nombre, email, fecha_nacimiento
    FROM examen_usuarios
    WHERE DATE_FORMAT(fecha_nacimiento, '%m-%d') = DATE_FORMAT(CURDATE(), '%m-%d')
      AND role = 'user'
");
$stmt->execute();
$usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);

foreach ($usuarios as $u) {
    $nombre = $u['nombre'];

    $mensaje = "
    <h2> ¡Feliz cumpleaños, $nombre! </h2>
    <p>Gracias por seguir formando parte de nuestra familia.</p>
    <p>Esperamos que tengas un día lleno de alegría.</p>
    <p><b>¡Te enviamos un gran abrazo!</b></p>
    ";

    enviar_correo($u['email'], " ¡Feliz Cumpleaños $nombre!", $mensaje);
}

echo "Correos de cumpleaños enviados.";
