<?php
if (session_status() === PHP_SESSION_NONE) session_start();

require_once __DIR__.'/../includes/config.php';
require_once __DIR__.'/../includes/functions.php';

// PHPMailer
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once __DIR__ . '/../includes/phpmailer/src/Exception.php';
require_once __DIR__ . '/../includes/phpmailer/src/PHPMailer.php';
require_once __DIR__ . '/../includes/phpmailer/src/SMTP.php';

// ---- LOGIN ----
if (isset($_POST['action']) && $_POST['action'] === 'login') {
    if (!csrf_check_token($_POST['csrf'] ?? '')) die("CSRF inválido");

    $email = trim($_POST['email'] ?? '');
    $pass  = $_POST['password'] ?? '';

    $stmt = $pdo->prepare("SELECT * FROM examen_usuarios WHERE email=?");
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user && password_verify($pass, $user['password'])) {
        $_SESSION['user'] = [
            'id'     => $user['id'],
            'email'  => $user['email'],
            'nombre' => $user['nombre'],
            'role'   => strtolower($user['role'])
        ];

        switch ($_SESSION['user']['role']) {
            case 'tech': header("Location: dashboard_tech.php"); break;
            case 'admin': header("Location: dashboard_admin.php"); break;
            default: header("Location: dashboard_user.php");
        }
        exit;
    } else {
        $login_error = "❌ Credenciales incorrectas.";
    }
}

// ---- REGISTRO ----
if (isset($_POST['action']) && $_POST['action'] === 'register') {
    if (!csrf_check_token($_POST['csrf'] ?? '')) die("CSRF inválido");

    $nombre = trim($_POST['nombre']);
    $apellidos = trim($_POST['apellidos']);
    $email = trim($_POST['email']);
    $telefono = trim($_POST['telefono']);
    $dni = strtoupper(trim($_POST['dni']));
    $pass1 = $_POST['password'];
    $pass2 = $_POST['password2'];
    $fecha_nacimiento = $_POST['fecha_nacimiento'];

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) $register_error = "Email inválido";
    elseif (!validate_dni($dni)) $register_error = "DNI inválido";
    elseif ($pass1 !== $pass2) $register_error = "Las contraseñas no coinciden";
    else {
        $stmt = $pdo->prepare("SELECT id FROM examen_usuarios WHERE email=?");
        $stmt->execute([$email]);
        if ($stmt->fetch()) $register_error = "Ya existe una cuenta con este correo.";
        else {
            $hash = password_hash($pass1, PASSWORD_DEFAULT);
            $token = bin2hex(random_bytes(16));
            $expira = date('Y-m-d H:i:s', strtotime('+1 day'));

            $stmt = $pdo->prepare("INSERT INTO examen_usuarios 
            (nombre, apellidos, dni, email, fecha_nacimiento, telefono, password, role, token, token_expira)
            VALUES (?, ?, ?, ?, ?, ?, ?, 'user', ?, ?)");

            $stmt->execute([$nombre, $apellidos, $dni, $email, $fecha_nacimiento, $telefono, $hash, $token, $expira]);

            try {
                $mail = new PHPMailer(true);
                $mail->isSMTP();
                $mail->Host       = 'mail.guiaviaje.com';
                $mail->SMTPAuth   = true;
                $mail->Username   = 'correo@guiaviaje.com';
                $mail->Password   = 'ciberweb69';
                $mail->SMTPSecure = 'tls';
                $mail->Port       = 587;

                $mail->setFrom('correo@guiaviaje.com', 'Reformas App');
                $mail->addAddress($email, $nombre);
                $mail->isHTML(true);
                $mail->Subject = "Bienvenido";
                $mail->Body = "Hola <strong>$nombre</strong>, tu registro fue exitoso.";

                $mail->send();
            } catch(Exception $e) {}

            $register_success = "✅ Registro completado. Ahora puedes iniciar sesión.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<title>Acceso</title>
<style>body {
  background: #f2f5fa;
  display: flex;
  justify-content: center;
  align-items: center;
  height: 100vh;
  font-family: Arial;
}

.container {
  background: white;
  width: 380px;
  padding: 25px;
  border-radius: 12px;
  box-shadow: 0 6px 20px rgba(0,0,0,0.15);
}

.tabs {
  display: flex;
  justify-content: space-between;
  margin-bottom: 15px;
}

.tab-btn {
  width: 50%;
  padding: 12px;
  border: none;
  cursor: pointer;
  background: #ddd;
}

.tab-btn.active {
  background: #4a6cf7;
  color: white;
  font-weight: bold;
}

.tab { display: none; }
.tab.active { display: block; }

input, button {
  width: 100%;
  padding: 8px;
  margin-top: 10px;
  border-radius: 6px;
  border: 1px solid #bbb;
}

button {
  background: #4a6cf7;
  color: white;
  cursor: pointer;
}

.error { color: red; margin-top: 10px; }
.success { color: green; margin-top: 10px; }

@media(max-width: 450px){
  .container { width: 100%; }
}
</style>
</head>
<body>

<div class="container">
    <div class="tabs">
        <button class="tab-btn active" data-tab="login">Iniciar Sesión</button>
        <button class="tab-btn" data-tab="register">Registrarse</button>
    </div>

    <div class="form-wrapper">

        <!-- LOGIN -->
        <form method="post" class="tab active" id="login">
            <?php if (!empty($login_error)) echo "<p class='error'>$login_error</p>"; ?>
            <input type="hidden" name="csrf" value="<?= e(csrf_get_token()) ?>">
            <input type="hidden" name="action" value="login">

            <input type="email" name="email" placeholder="Correo" required>
            <input type="password" name="password" placeholder="Contraseña" required>
            <button>Entrar</button>
            <p><a href="recover.php">¿Olvidaste tu contraseña?</a></p>
        </form>

        <!-- REGISTRO -->
        <form method="post" class="tab" id="register">
            <?php 
            if (!empty($register_error)) echo "<p class='error'>$register_error</p>";
            if (!empty($register_success)) echo "<p class='success'>$register_success</p>";
            ?>
            <input type="hidden" name="csrf" value="<?= e(csrf_get_token()) ?>">
            <input type="hidden" name="action" value="register">

            <input type="text" name="nombre" placeholder="Nombre" required>
            <input type="text" name="apellidos" placeholder="Apellidos" required>
            <input type="text" name="dni" placeholder="DNI" required>
            <input type="email" name="email" placeholder="Correo" required>
            <input type="date" name="fecha_nacimiento" required>
            <input type="text" name="telefono" placeholder="Teléfono" required>
            <input type="password" name="password" placeholder="Contraseña" required>
            <input type="password" name="password2" placeholder="Repetir Contraseña" required>
            <button>Registrar</button>
        </form>
    </div>
</div>

<script>
document.querySelectorAll(".tab-btn").forEach(btn=>{
    btn.onclick = ()=>{
        document.querySelector(".tab-btn.active").classList.remove("active");
        btn.classList.add("active");

        document.querySelector(".tab.active").classList.remove("active");
        document.getElementById(btn.dataset.tab).classList.add("active");
    };
});
</script>

</body>
</html>
