<?php
// 🔹 Iniciar sesión al principio (antes de cualquier salida)
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/functions.php';

// 🔹 Si el usuario ya inició sesión, redirige automáticamente
if (!empty($_SESSION['user'])) {
    $role = strtolower($_SESSION['user']['role'] ?? '');
    echo "<p>Ya has iniciado sesión como <strong>{$role}</strong>.</p>";

    switch ($role) {
        case 'tech':
            echo '<p><a href="dashboard_tech.php">Ir al panel técnico</a></p>';
            break;
        case 'admin':
            echo '<p><a href="dashboard_admin.php">Ir al panel de administrador</a></p>';
            break;
        default:
            echo '<p><a href="dashboard_user.php">Ir al panel de usuario</a></p>';
    }

    echo '<p><a href="logout.php">Cerrar sesión</a></p>';
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // 🔹 Verificar CSRF
    if (!csrf_check_token($_POST['csrf'] ?? '')) {
        error_log("Token en sesión: " . ($_SESSION['csrf_token'] ?? 'NO EXISTE'));
        error_log("Token recibido: " . ($_POST['csrf'] ?? 'NO ENVIADO'));
        die("CSRF inválido");
    }

    $email = trim($_POST['email'] ?? '');
    $pass  = $_POST['password'] ?? '';

    // 🔹 Buscar usuario (nombre correcto de la tabla)
    $stmt = $pdo->prepare('SELECT * FROM examen_usuarios WHERE email = ?');
    $stmt->execute([$email]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    // ✅ Comparar usando password_verify (por contraseñas encriptadas)
    if ($user && password_verify($pass, $user['password'])) { 
        $_SESSION['user'] = [
            'id'     => $user['id'],
            'email'  => $user['email'],
            'nombre' => $user['nombre'],  // ojo: aquí debe ser 'nombre', no 'Nombre'
            'role'   => strtolower($user['role'] ?? '')
        ];

        // Cookie segura
        setcookie('session_user', hash('sha256', $user['email'] . session_id()), time() + 3600, '/', '', true, true);

        // Redirección por perfil
        $role = $_SESSION['user']['role'];
        switch ($role) {
            case 'tech':
                header('Location: dashboard_tech.php');
                break;
            case 'admin':
                header('Location: dashboard_admin.php');
                break;
            default:
                header('Location: dashboard_user.php');
        }
        exit;
    } else {
        $error = "❌ Credenciales incorrectas.";
    }
}
?>
<!doctype html>
<html lang="es">
<head>
<meta charset="utf-8">
<title>Iniciar Sesión</title>
<link rel="stylesheet" href="assets/css/style_login.css">
<script src="assets/js/app.js"></script>
</head>
<body>

<?php if (!empty($error)) echo "<p style='color:red'>$error</p>"; ?>

<form method="post">
<div class="login">
  <div class="form">
    <h2>Iniciar Sesión</h2>
      <input type="hidden" name="csrf" value="<?php echo e(csrf_get_token()); ?>">
  
  <label>Email</label>
  <input type="email" name="email" required>

  <label>Contraseña</label>
  <input type="password" name="password" required>

  <input type="submit" value="entrar" class="submit">
    </input>
  </button>
  <p><a href="recover.php">¿Olvidaste la contraseña?</a></p>
<p><a href="register.php">Registrarse</a></p>
</div>
</form>


</body>
</html>
