<?php
require_once __DIR__ . '/../includes/config.php';
require_once __DIR__ . '/../includes/mailer.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');

    // Verificar si existe el usuario
    $stmt = $pdo->prepare("SELECT id FROM examen_usuarios WHERE email=?");
    $stmt->execute([$email]);
    $user = $stmt->fetch();

    if ($user) {
        // Crear token y guardar
        $token = bin2hex(random_bytes(16));
        $expira = date("Y-m-d H:i:s", time() + 3600);

        $stmt = $pdo->prepare("UPDATE examen_usuarios SET token=?, token_expira=? WHERE email=?");
        $stmt->execute([$token, $expira, $email]);

        // ✅ Enviar correo
        send_recovery_email($email, $token);
    }

    echo "<script>alert('Si el correo existe, se ha enviado un enlace de recuperación.');location.href='index.php';</script>";
    exit;
}
?>

<style>
body {
    background: #f2f5fa;
    font-family: Arial;
    display: flex; justify-content: center; align-items: center;
    height: 100vh; margin: 0;
}
.container {
    background: white; padding: 25px 35px;
    border-radius: 12px; width: 380px; text-align: center;
    box-shadow: 0px 6px 20px rgba(0,0,0,0.15);
}
input {
    width: 100%; padding: 12px; margin-top: 10px;
    border: 1px solid #bbb; border-radius: 6px;
}
button {
    width: 100%; padding: 12px; margin-top: 20px;
    background: #4a6cf7; color: white; border: none;
    border-radius: 6px; cursor: pointer; font-size: 16px;
}
.error { background: #ffe5e5; padding: 10px; color: #d60000; margin-bottom: 15px; border-radius: 6px; }
.success { background: #e5ffe8; padding: 10px; color: #0b6b1b; margin-bottom: 15px; border-radius: 6px; }
</style>

<form method="post">
<div class="login">
  <div class="form">
    <h2>Recuperación de Password</h2>
    <input type="email" name="email" required placeholder="Tu correo">
    <input type="submit" value="Enviar enlace" class="submit">
  </div>
</div>
  </form>
