<?php
if (session_status() === PHP_SESSION_NONE) session_start();

require_once __DIR__.'/../includes/config.php';
require_once __DIR__.'/../includes/functions.php';

// ⚡ PHPMailer
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require_once __DIR__ . '/../includes/phpmailer/src/Exeption.php';
require_once __DIR__ . '/../includes/phpmailer/src/PHPMailer.php';
require_once __DIR__ . '/../includes/phpmailer/src/SMTP.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (!csrf_check_token($_POST['csrf'] ?? '')) die("CSRF inválido");

    // ✅ Recoger variables del formulario
    $nombre    = trim($_POST['nombre'] ?? '');
    $apellidos = trim($_POST['apellidos'] ?? '');
    $email     = trim($_POST['email'] ?? '');
    $telefono  = trim($_POST['telefono'] ?? '');
    $dni       = strtoupper(trim($_POST['dni'] ?? ''));
    $pass1     = $_POST['password'] ?? '';
    $pass2     = $_POST['password2'] ?? '';
    $fecha_nacimiento = $_POST['fecha_nacimiento'] ?? null; // si no existe en el formulario, será NULL

    // Validaciones básicas
    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) die("Email inválido");
    if (!validate_dni($dni)) die("DNI/NIF inválido");
    if ($pass1 !== $pass2) die("Las contraseñas no coinciden");

    // ¿Ya existe?
    $stmt = $pdo->prepare('SELECT id FROM examen_usuarios WHERE email = ?');
    $stmt->execute([$email]);
    if ($stmt->fetch()) die("El usuario ya está registrado.");

    // ✅ Variables faltantes
    $password_hash = password_hash($pass1, PASSWORD_DEFAULT);
    $role = 'user'; // valor por defecto
    $token = bin2hex(random_bytes(16)); // genera un token aleatorio
    $token_expira = date('Y-m-d H:i:s', strtotime('+1 day')); // expira en 24h

    // ✅ Insertar usuario en la base de datos
    $stmt = $pdo->prepare("INSERT INTO examen_usuarios 
    (nombre, apellidos, dni, email, fecha_nacimiento, telefono, password, role, token, token_expira)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

$stmt->execute([
    $nombre,
    $apellidos,
    $dni,
    $email,
    $fecha_nacimiento,
    $telefono,
    $password_hash,
    $role,
    $token,
    $token_expira
]);

    // ✅ Enviar correo de bienvenida
    try {
        $mail = new PHPMailer(true);
        $mail->isSMTP();
        $mail->Host       = 'mail.guiaviaje.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'correo@guiaviaje.com';
        $mail->Password   = 'ciberweb69';
        $mail->SMTPSecure = 'tls';
        $mail->Port       = 587;

        $mail->setFrom('correo@guiaviaje.com', 'Reformas App');
        $mail->addAddress($email, $nombre);

        $mail->isHTML(true);
        $mail->Subject = 'Bienvenido a Reformas App';
        $mail->Body    = "Hola <strong>$nombre</strong>,<br>Tu registro fue exitoso. Ya puedes iniciar sesión.";

        $mail->send();
    } catch (Exception $e) {
        error_log("Mailer Error: " . $mail->ErrorInfo);
    }

    echo "<p>✅ Registro completado correctamente. Se ha enviado un correo de bienvenida.</p>";
    echo "<p><a href='login.php'>Ir al login</a></p>";
    exit;
}
?>
<!doctype html>
<html lang="es">
<head>
<meta charset="utf-8">
<title>Registro</title>
<link rel="stylesheet" href="assets/css/style_login.css">
<script src="assets/js/app.js"></script>
</head>
<body>
<form method="post">
<div class="login">
  <div class="form">
    <h2>Registro de usuario</h2>
    <input type="hidden" name="csrf" value="<?= e(csrf_get_token()) ?>">

    <label>Nombre</label>
    <input type="text" name="nombre" required>

    <label>Apellidos</label>
    <input type="text" name="apellidos" required>

    <label>DNI/NIF</label>
    <input type="text" name="dni" required>

    <label>Email</label>
    <input type="email" name="email" required>
    <label>Fecha de nacimiento</label>
<input type="date" name="fecha_nacimiento" required>

    <label>Teléfono</label>
    <input type="text" name="telefono" required>

    <!-- ⚠️ Si quieres capturar fecha de nacimiento, agrega este campo -->
    <!-- <label>Fecha de nacimiento</label>
    <input type="date" name="fecha_nacimiento"> -->

    <label>Contraseña</label>
    <input type="password" name="password" required>

    <label>Repite Contraseña</label>
    <input type="password" name="password2" required>

    <input type="submit" value="Registrar" class="submit">
  </div>
</div>
</form>
</body>
</html>
