<?php
// Iniciar sesión si no está activa
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

/**
 * Escapa una cadena para salida HTML
 */
function e($str) {
    return htmlspecialchars($str, ENT_QUOTES, 'UTF-8');
}

/**
 * Genera un token CSRF y lo guarda en sesión
 */
function csrf_get_token() {
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

/**
 * Verifica un token CSRF
 */
function csrf_check_token($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

/**
 * Valida DNI/NIF español
 * @param string $dni
 * @return bool
 */
function validate_dni($dni) {
    $dni = strtoupper(trim($dni));
    // DNI con 8 números + letra
    if (preg_match('/^\d{8}[A-Z]$/', $dni)) {
        $numero = substr($dni, 0, 8);
        $letra  = substr($dni, -1);
        $letras = 'TRWAGMYFPDXBNJZSQVHLCKE';
        return $letra === $letras[$numero % 23];
    }
    // NIE (X,Y,Z) + 7 números + letra
    if (preg_match('/^[XYZ]\d{7}[A-Z]$/', $dni)) {
        $letra = substr($dni, -1);
        $numero = str_replace(['X','Y','Z'], ['0','1','2'], substr($dni,0,-1));
        $letras = 'TRWAGMYFPDXBNJZSQVHLCKE';
        return $letra === $letras[$numero % 23];
    }
    return false;
}
?>
