<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require __DIR__ . '/phpmailer/src/PHPMailer.php';
require __DIR__ . '/phpmailer/src/SMTP.php';
require __DIR__ . '/phpmailer/src/Exception.php';

function enviar_correo($to, $subject, $body, $from_name = 'Mi App', $from_email = 'noreply@guiaviaje.com') {
    $mail = new PHPMailer(true);

    try {
        $mail->isSMTP();
        $mail->SMTPDebug = 2;
        $mail->Debugoutput = 'html';
        $mail->Host       = 'mail.guiaviaje.com';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'correo@guiaviaje.com';
        $mail->Password   = 'ciberweb69';
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port       = 587;

        $mail->setFrom($from_email, $from_name);
        $mail->addAddress($to);
        $mail->isHTML(true);
        $mail->Subject = $subject;
        $mail->Body    = $body;

        $mail->send();
        return true;

    } catch (Exception $e) {
        error_log("Error enviando correo a $to: " . $mail->ErrorInfo);
        return false;
    }
}

function send_recovery_email($email, $token) {
    $link = "https://daniel.guiaviaje.com/examenes/3/html/recover_reset.php?token=$token";
    $asunto = "Recuperación de contraseña";
    $mensaje = "
        <h3>Recuperación de contraseña</h3>
        <p>Haz clic en el siguiente enlace para restablecer tu contraseña:</p>
        <p><a href='$link'>$link</a></p>
        <p>Si no solicitaste este cambio, ignora este correo.</p>
    ";
    return enviar_correo($email, $asunto, $mensaje);
}


/**
 * Enviar correos desde el panel técnico
 */
function send_panel_email($pdo, $asunto, $mensaje, $destinatario_email = null, $role = null, $fecha_programada = null) {
    if ($fecha_programada) {
        // Guardar mensaje programado
        $stmt = $pdo->prepare("
            INSERT INTO examen_mensajes (destinatario_email, role_destinatario, asunto, mensaje, fecha_programada)
            VALUES (?, ?, ?, ?, ?)
        ");
        $stmt->execute([$destinatario_email, $role, $asunto, $mensaje, $fecha_programada]);
        return true;

    } else {
        // Envío inmediato
        if ($destinatario_email) {
            return enviar_correo($destinatario_email, $asunto, $mensaje);
        } elseif ($role) {
            $stmt = $pdo->prepare("SELECT email FROM examen_usuarios WHERE role = ?");
            $stmt->execute([$role]);
            $usuarios = $stmt->fetchAll();
            foreach ($usuarios as $u) {
                enviar_correo($u['email'], $asunto, $mensaje);
            }
            return true;
        }
    }
}
?>
